/*---------------------------------------------------------------------------*\

	FILE....: playtone.cpp
	TYPE....: C Program
	AUTHOR..: David Rowe
	DATE....: 13/2/01

	Test program that plays a tone out of one VPB port. Used during 
	development of V4PCI prototype.

	Compile: gcc playtone.cpp -o playtone -lvpb -lm -pthread -Wall

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../src/vpbapi.h"
#include "kbhit.h"

#define SINAMP 32767.0
#define FS     8000.0
#define N      160

int arg_exists(int argc, char *argv[], char *arg);
void sin_buf(short buf[], float f, int n);

int main(int argc, char *argv[]) 
{
	int	      h;
	int           ch_num;
	short         buf[N];

	if (argc == 1) {
		printf("usage: ./playtone Ch[1..]\n");
		exit(0);
	}
	h = vpb_open(1,1);
	vpb_close(h);

	ch_num = atoi(argv[1]);
	h = vpb_open(1, ch_num);

	vpb_sethook_sync(h, VPB_OFFHOOK);
	printf("Playing tone - press return to finish\n");

	vpb_play_buf_start(h, VPB_LINEAR);
	while(!kbhit()) {
                sin_buf(buf, 1000.0, N);
		vpb_play_buf_sync(h, (char*)buf, sizeof(buf));
	}

	vpb_play_buf_finish(h);

	vpb_sethook_sync(h, VPB_ONHOOK);
	vpb_close(h);	

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

// generates a buffer of sinusoidal samples
void sin_buf(short buf[], float f, int n) {
	int        i;
	static int t;
	float      sam;

	for(i=0; i<n; i++) {
		sam = SINAMP*cos(2.0*3.141*(t++)*f/FS);
		buf[i] = (short)sam;

	}
}

